document.addEventListener('DOMContentLoaded', function () {
    const canvas = document.getElementById('drawingCanvas');
    const context = canvas.getContext('2d');
    const showSolutionBtn = document.getElementById('showSolutionBtn');
    const solutionImage = document.getElementById('solutionImage');
    const initialImage = new Image();
    initialImage.src = 'media/images/exer3.png';
    let drawing = false;
    let drawColor = '#000000'; // Default drawing color

    // Ensure the initial image is loaded before drawing it on the canvas
    initialImage.onload = function() {
        context.drawImage(initialImage, 0, 0, canvas.width, canvas.height);
    };

    canvas.addEventListener('mousedown', startDrawing);
    canvas.addEventListener('mouseup', stopDrawing);
    canvas.addEventListener('mousemove', draw);

       // Event listener for color picker
       colorPicker.addEventListener('input', function() {
        drawColor = colorPicker.value;
    });

    function startDrawing(e) {
        drawing = true;
        draw(e);  // Draw a point where the mouse is pressed
    }

    function stopDrawing() {
        drawing = false;
        context.beginPath();  // Reset the drawing path
    }

    function draw(e) {
        if (!drawing) return;

        context.lineWidth = 5;
        context.lineCap = 'round';
        context.strokeStyle = drawColor; // Use the selected color

        const rect = canvas.getBoundingClientRect();
        context.lineTo(e.clientX - rect.left, e.clientY - rect.top);
        context.stroke();
        context.beginPath();
        context.moveTo(e.clientX - rect.left, e.clientY - rect.top);
    }

    showSolutionBtn.addEventListener('click', function () {
        solutionImage.style.display = 'block';
        solutionImage.style.width = canvas.width + 'px';
        solutionImage.style.height = canvas.height + 'px';
        solutionImage.style.left = canvas.offsetLeft + 'px';
        solutionImage.style.top = canvas.offsetTop + 'px';
    });
});





