// Function for Task 1
function checkAnswerTask1(correctAnswer, radioGroupName, feedbackId) {
  const radioButtons = document.getElementsByName(radioGroupName);
  let selectedAnswer = null;

  for (const radioButton of radioButtons) {
    if (radioButton.checked) {
      selectedAnswer = radioButton.value;
      break;
    }
  }

  const feedbackElement = document.getElementById(feedbackId);

  if (selectedAnswer === "3") {
    feedbackElement.textContent = "Correct!";
  } else if (selectedAnswer) {
    feedbackElement.textContent = "Incorrect. Please look at the NWP data one more time and try again.";
  } else {
    feedbackElement.textContent = "Please select an answer.";
  }
}

// Function for Task 2
function checkAnswerTask2(correctAnswer, radioGroupName, feedbackId) {
  const radioButtons = document.getElementsByName(radioGroupName);
  let selectedAnswer = null;

  for (const radioButton of radioButtons) {
    if (radioButton.checked) {
      selectedAnswer = radioButton.value;
      break;
    }
  }

  const feedbackElement = document.getElementById(feedbackId);
  const responseElement = document.getElementById("response");

  if (selectedAnswer) {
    // Store the selected answer in local storage
    localStorage.setItem("selectedAnswerTask2", selectedAnswer);
    // Provide immediate feedback
    responseElement.textContent = "Your answer has been saved.";
  } else {
    responseElement.textContent = "Please select an answer.";
  }

  if (selectedAnswer) {
    if (selectedAnswer === correctAnswer) {
      feedbackElement.textContent = " Correct!";
    } else {
      feedbackElement.textContent = " Incorrect. Please review your answer.";
    }
  }
}


// Helper function to get the answer label
function getAnswerLabel(answerValue) {
  switch (answerValue) {
    case "a":
      return "a) No storm will form over Hungary.";
    case "b":
      return "b) Storms will form over the whole of Hungary.";
    case "c":
      return "c) Storms will form in the afternoon in the northeastern part of Hungary.";
    case "d":
      return "d) Storms will form by the late morning in the northeastern part of Hungary.";
    default:
      return "Unknown";
  }
}

// Helper function to check if the answer is correct
function isAnswerCorrect(answerValue) {
  return answerValue === "d";
}

// Call the function to display the stored answer on the other page
displayStoredAnswer();





/*END*/









  


