$(document).ready(function() {
	
		// Some options for customization
		var topgap = 5;		/* gap on the left */
		var bottomgap = 5;		/* gap on the right */
		var leftgap = 5;		/* gap on the left */
		var rightgap = 5;		/* gap on the right */
		var defaultgap = 40;	/* the intro gap */
		var caption = false;		/* toggle caption */
		var reveal = 0.5;		/* define 0 - 1 far does it goes to reveal the second caption */
		
		// find each of the .beforeafter
		$('.fourSlider').each(function () {
		
			// set current selected item to variable
			var i = $(this);			
			// get the source of the first image and second image using eq(index)
			var img_mask = i.children('img:eq(0)').attr('src');
			var img_bg = i.children('img:eq(1)').attr('src');
                var img_telon = i.children('img:eq(2)').attr('src');
			var img_esqui = i.children('img:eq(3)').attr('src');
			
			// get the caption for the first image as default caption
			var img_cap_one = i.children('img:eq(0)').attr('alt');
			
			// get the dimension of the first image, assuming second image has the same dimension
			var width = i.children('img:eq(0)').width();
			var height = i.children('img:eq(0)').height();
			
			// hide the images, not removing it because we will need it later
			i.find('img').hide();		
			
			// set some css attribute to current item
			i.css({'overflow': 'hidden', 'position': 'relative'});
			
			// append additional html element
			i.append('<div class="ba-mask"></div>');
			i.append('<div class="ba-bg"></div>');	
			i.append('<div class="ba-telon"></div>');	
			i.append('<div class="ba-esqui"></div>');	
			i.append('<div class="ba-caption">' + img_cap_one + '</div>');		
			
			
			// set the dimension of appended html element
			i.children('.ba-mask, .ba-bg , .ba-telon, .ba-esqui').width(width);
			i.children('.ba-mask, .ba-bg , .ba-telon, .ba-esqui').height(height);
			
			// set the images as background for ba-mask and ba-bg
			i.children('.ba-mask').css('backgroundImage','url(' + img_mask + ')');
			i.children('.ba-bg').css('backgroundImage','url(' + img_bg + ')');	
			i.children('.ba-telon').css('backgroundImage','url(' + img_telon + ')');
			i.children('.ba-esqui').css('backgroundImage','url(' + img_esqui + ')');			

			// animate to reveal the background image
			i.children('.ba-telon').animate({'height':height - defaultgap}, 1000);
			i.children('.ba-mask').animate({'width':width - defaultgap}, 1000);
			i.children('.ba-esqui').animate({'width':width - defaultgap}, 1000);
					

			// if is true, then display it, otherwise, hide it
			if (caption) i.children('.ba-caption').show();
			else i.children('.ba-caption').hide();

			
			
		}).mousemove(function (e) {

			// set current selected item to variable
			var i = $(this);
			
			// get the position of the image
			pos_img = i.offset()['left'];
			pos_imgv = i.offset()['top'];
			pos_imgh = i.offset()['right'];
			
			// get the position of the mouse pointer
			pos_mouse = e.pageX;	
			pos_mousev = e.pageY;	
			//pos_mouseh = e.pageX;
			
			// calculate the difference between the image and cursor
			// the difference will the width of the mask image
			new_width = pos_mouse - pos_img;
			img_width = i.width();

			new_height = pos_mousev - pos_imgv;
			img_height = i.height();

			
			
			// get the captions for first and second images
			
			img_cap_one =   i.children('img:eq(0)').attr('alt');
			img_cap_two =   i.children('img:eq(1)').attr('alt');
			img_cap_three = i.children('img:eq(2)').attr('alt');
			img_cap_four =  i.children('img:eq(3)').attr('alt');
			
			/*
			img_cap_one =   "";
			img_cap_two =   "";
			img_cap_three = "";
			img_cap_four =  "";
			*/
			
			/*
			// for debugging purposes
			$('#debug').html("X Axis : " + e.pageX + " | Y Axis " + e.pageY);
			$('#debug2').html(i.position()['left']);
			$('#debug3').html(new_width);
			*/
			
			// make sure it reveal the image and left some gaps on left and right
			// it depends on the value of leftgap and rightgap




			if (new_height > topgap && new_height < (img_height - bottomgap)) {			
				i.children('.ba-telon').height(new_height);
			}


			if (new_width > leftgap && new_width < (img_width - rightgap)) {			
				i.children('.ba-mask').width(new_width);
			 }	
	
			if (new_width > rightgap && new_width < (img_width - leftgap)) {			
				i.children('.ba-esqui').width(new_width);
				i.children('.ba-esqui').height(new_height);
			 }

		



			 
			if (new_height < (img_height * reveal)) {	

		      if (new_width < (img_width * reveal)) {			
				i.children('.ba-caption').html(img_cap_two);
			    } else {
				i.children('.ba-caption').html(img_cap_one);			
			   };


			} else {

			  if (new_width < (img_width * reveal)) {			
				i.children('.ba-caption').html(img_cap_three);
			    } else {
				i.children('.ba-caption').html(img_cap_four);			
			   };

		
			}	 								
			


		});
		
	  });